//#include <stdio.h>
//#include "math.h"
#include "tc_vars.h"
//#include "hardware_t.h"
//#include "flash_t.h"
//#include "display_t.h"
//#include "floatstr_t.h"
#include "signal_t.h"
//#include "interface_t.h"

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							Class Signal
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/*
void Signal::Template(void)
{


}
*/

//##########################################################################################################################################################
// BF function for USTB roll mode

void Signal::USTB_Clear_Buffer(void)
{
	int lVirtual_Zero=0;
	int lChannel=0;

	USTB_Roll_idx = 0; //Set pointer to beginning

	//init buffers with ground signal
	for(lChannel = 1;lChannel <= 5;lChannel++)
	{
		switch(lChannel)
		{	
			case 1 :	//Channel 1
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL1_USTB[i] = (char)lVirtual_Zero;

				break;
			}
	
			case 2 :	//Channel 2
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL2_USTB[i] = (char)lVirtual_Zero;

				break;
			}

			case 3 :	//Channel 3
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / scale_factor[Selected_Voltage_CH3][GainIdx]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL3_USTB[i] = (char)lVirtual_Zero;

				break;
			}

			case 4 :	//Channel 4
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / scale_factor[Selected_Voltage_CH4][GainIdx]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL4_USTB[i] = (char)lVirtual_Zero;

				break;
			}

			case 5 :	//Channel math
			{				
				for(int i=0;i<1200;i++) SIGNALM_USTB[i] = ADC_ZERO;
				break;
			}
	
	
		}
	
	}

}
//##########################################################################################################################################################
// BF function for USTB roll mode

void Signal::USTB_roll_signal(int Time_idx, unsigned char *DataArray_in, unsigned char *Signal)
{

	int lNew_Value=0;
	int lix;

	//calculate average value of ADC data array
	for (lix = 0; lix < 128; lix++)
	{ lNew_Value += DataArray_in[lix]; }

	lNew_Value = lNew_Value >> 7;

	//write new value to the current time position
	Signal[Time_idx] = (char)lNew_Value;

//	Signal[Time_idx] = DataArray_in[1];
	
}

//##########################################################################################################################################################
// BF function for USTB shift mode

void Signal::USTB_shift_signal(unsigned char *DataArray_in, unsigned char *Signal)
{

	int lNew_Value=0;
	int lix;

	//calculate average value of ADC data array
	for (lix = 0; lix < 128; lix++)
	{ lNew_Value += DataArray_in[lix]; }

	lNew_Value = lNew_Value >> 7;
	
	//shift all value one position to the right
	for (lix = GRID_WIDTH;lix >= 0;lix--)
	{ Signal[lix+1] = Signal[lix]; }

	 //copy new value on the first position
	Signal[0] = (char)lNew_Value;

}

//##########################################################################################################################################################
/* BF */
// Build trigonometric tables for FFT
void Signal::FFT_BuildTrigoTables(void)
{
	//Speicher auf dem Stack reservieren
	int z,l,i,r,ct,buff; 	//,ar,v, la;
	int d[FFT_Level];	//Number of butterfly levels

	//Struktur vom Typ div_t erzeugen
	div_t s_div;

/*
	Signal::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
	Signal::TEXTOUTxvbig("Building trigonometric", 247, 192, 1, UI_Plane2);
	Signal::TEXTOUTxvbig("tables.", 247, 212, 1, UI_Plane2);
	Signal::TEXTOUTxvbig("Please wait a minute.", 247, 232, 1, UI_Plane2);
*/

/*
	// create sin() and cos() table as integer values
	for(i=0;i < FFT_Length;i++)  			
	{
		sin_tab[i] = (int)(FFT_INTFACT * sin(i*2*PI/FFT_Length));
		cos_tab[i] = (int)(FFT_INTFACT * cos(i*2*PI/FFT_Length));
	}
*/	
	// create window and trigonometric tables
	for(i=0,r=0 ;i < FFT_Length; i++)
	{
		sin_tab[i] = iSin1024[r];
		cos_tab[i] = iCos1024[r];

		win_tab[i] = FFT_Window[FFT_Windex][r];
	
		if (FFT_Length == FFT_512)
		r+=2;
		else
		r++;	
	}

	
	//Bit-Reversal- Tabelle bit_rev[0..] anlegen
	for(i=0 ;i < FFT_Length; i++)
	{
		z=i;
		//Dezimal-Index in Dualzahl umwandeln
		for(ct=0 ;ct < FFT_Level; ct++)
		{
			s_div = div(z,2);
			d[ct] = (int)s_div.rem;		// den Rest ins Feld
			z     = (int)s_div.quot;	// den Quotienten nach z
		}
		//Bit-Revers anordnen
		s_div = div(FFT_Level,2);
		for(ct=0 ;ct < (int)s_div.quot; ct++)
		{
			buff  = d[ct];
			d[ct] = d[FFT_Level-ct-1];
			d[FFT_Level-ct-1] = buff;
		}
		
		//Bit-Revers anordnen Zeitoptimiert mit Festwert
//		for(int buff,j=0;j<5;j++) 	        // 5 = FFT_LEVEL/radix  => x=div(FFT_LEVEL,2) => x.quot=5
//		{
//			buff 	     = d[j];
//			d[j] 	     = d[FFT_LEVEL-j-1];
//			d[FFT_LEVEL-j-1] = buff;
//		}

		//Umsortierten Index zurückwandeln in Dezimalzahl
		r = 0;
		for(ct=0 ;ct < FFT_Level; ct++)
		{
			r = r + (1<<ct) * d[ct];
		}
		//umsortierter Index
		bit_rev[i] = r;

	}//Ende Bit-Reversal-Tabelle
/*	
	//Delete popup
	Signal::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
	Signal::TEXTOUTxvbig("Building trigonometric", 247, 192, 0, UI_Plane2);
	Signal::TEXTOUTxvbig("tables.", 247, 212, 0, UI_Plane2);
	Signal::TEXTOUTxvbig("Please wait a minute.", 247, 232, 0, UI_Plane2);
*/
/*
	//check the values
	for(i=0;i < FFT_Length;i++)  			// {sin und cos-Tabelle prüfen}
	{
		//printf("SIN(x) = ");floatprintf((float)sin_tab[i]);
		//printf("COS(x) = ");floatprintf((float)cos_tab[i]);printf("\r\n");
		printf("SIN(x) =  %d\r\n",sin_tab[i]);
		printf("COS(x) =  %d\r\n",cos_tab[i]);

	}
	//check the values
//	for(Ii=0 ;Ii < FFT_LENGTH; Ii++)
//	printf("Bit reversal =  %d\r\n",bit_rev[Ii]);

*/

}

//##########################################################################################################################################################
/* BF */
// Calculate fast fourier transformation to get spectral analyzis of time signal. Trigonometric tables have to be build first.
// To get a periodic approximation, the time signal has to be processed with a window function. The simplest case is a 
// rectangle window, which has no side line suppression.
void Signal::FFT_CalcSpectrum(unsigned char *Signal, int *Spectrum)
{
	// buffer for real and imaginary part of spectrum - sharing the memory with the signal interpolation
	int *freq_re = (int *)0x008DDD20;
	int *freq_im = (int *)0x008DF490;
	
	//Speicher auf dem Stack reservieren
	int l=0,i=0,j=0,r=0,ar=0,v=0;
	int Fz1=0,Fz2=0,Fz3=0,Fz4=0,Fxr=0,Fxi=0,Fyr=0,Fyi=0;
	int ScaleShiftFactor;  
	
	double logval;
    	//printf("starting fft\r\n");
	
	// set variable scaling
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	FFT_Scale = 3;
	else
	FFT_Scale = 2;

	ScaleShiftFactor = FFT_Level - FFT_Scale;

	//-----------------------------------------------
	// get time signal and make a window overlay
	//-----------------------------------------------

	//sort timevalues bitreversal
	for(i=0;i<FFT_Length;i++)
	{
		if(FFT_Windex == -1)
		freq_re[i] = (int)(Signal[bit_rev[i]] - ADC_ZERO);					// no window overlay -> rectangle
		else
		freq_re[i] =  (win_tab[bit_rev[i]] * (int)(Signal[bit_rev[i]] - ADC_ZERO)) >> 13;	// window overlay

		freq_im[i] = 0;

		//printf("freq_re[%d] = ",Ii);floatprintf(freq_re[Ii]);
		//printf("     freq_im[%d] = ",Ii);floatprintf(freq_im[Ii]);printf("\r\n");
	}

	//-----------------------------------------------
	//             calculate FFT
	//-----------------------------------------------

	//calculate complex spectral values (butterflies)
	for(l=1;(l<=FFT_Level) && !UI_request;l++)	// level loop
	{
		for(i=0;i<=((1<<(FFT_Level-l))-1) && !UI_request;i++)
		{
			for(j=0;j<=((1<<(l-1))-1);j++)
			{
				r = j + i* (1 << l);
				ar= j * (FFT_Length >> l);
				v = 1 << (l-1);
				
				Fz1 = (cos_tab[ar] * freq_re[r+v]) >> 10;	//rescale from integer conversion
				Fz2 = (cos_tab[ar] * freq_im[r+v]) >> 10;	//rescale from integer conversion
				Fz3 = (sin_tab[ar] * freq_re[r+v]) >> 10;	//rescale from integer conversion
				Fz4 = (sin_tab[ar] * freq_im[r+v]) >> 10;	//rescale from integer conversion
				Fxr = freq_re[r] + Fz1 + Fz4;
				Fxi = freq_im[r] - Fz3 + Fz2;
				Fyr = freq_re[r] - Fz1 - Fz4;
				Fyi = freq_im[r] + Fz3 - Fz2;
				freq_re[r] = Fxr;
				freq_im[r] = Fxi;
				freq_re[r+v] = Fyr;
				freq_im[r+v] = Fyi;
			}
		}
	}


	//get half of the spectrum because spectrum is mirrored at the middle and calculate output
	for (i=0,j=0;i < (FFT_Length>>1)  && !UI_request;i++)
	{
		//downscale depending on FFT length
		freq_re[i] = freq_re[i] >> ScaleShiftFactor;
		freq_im[i] = freq_im[i] >> ScaleShiftFactor;

		switch(FFT_Mode)
		{
			case FFT_MAGN: 	// linear magnitude
			{
				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²

				// and square root
				for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
				r = (r + (v / r)) >> 1;
				
				break;
			}
			
			case FFT_PHAS: 	// linear phase
			{
				r = 10;
				//phase = arctan(imag / real)
				break;
			}

			case FFT_REAL: 	// linear real part
			{
				r = freq_re[i];
				
				break;
			}

			case FFT_IMAG: 	// linear imaginary part
			{
				r = freq_im[i];
				
				break;
			}

			case FFT_REIM: 	// linear real + imaginary
			{
				r = freq_re[i] + freq_im[i];
				
				break;
			}

			case FFT_PWSP: 	// power spectrum in dBm
			{
				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²

				// and square root
				for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
				r = (r + (v / r)) >> 1;

				//limiter
				if (r < 0) r = 0;
				if (r > 480) r = 480;

				// calculate logarithm
				r = (int)iLog10[r];

/*
				//limiter
				if (r < 0) r = 0;
				if (r > 480) r = 480;

				// calculate power spectrum
				// ps = 20 * log10(magn / ref)		ref = 0.316 V = 323 / 1024
				
				r = (r * 323) >> 10;			//magn / ref
				
				r = (int)iLog10[r];			//20 * log10(magn / ref)
*/				
				break;			}

			case FFT_PWDN: 	// power density spectrum in dBm
			{
				// calculate power density spectrum
				// pd = ps - 10 * log10(ENBW * df)

				r = 10;
				
				break;
			}

		}

		//printf("freq_re[%d] = %d    ",i,freq_re[i]);
		//printf("freq_im[%d] = %d    ",i,freq_im[i]);	

		
		//printf("v = Re² + IM² = %d    ",v);
		

		//printf("r = sqrt(v) = %d",r);
		
		// scale to display size
		//r = r << 2;
		//printf("scale r = %d\r\n",r);	

		
		//map to 512 or 1024 values
		if(FFT_Length == FFT_1024 )
			Spectrum[i] = r;
		else
		{ 
			Spectrum[j] = r;
			Spectrum[j+1] = r;
			j+=2;
		 }	
		
	}

    	//printf("finished fft\r\n");
}

//##########################################################################################################################################################
//multiply signals
void Signal::CalcMathMul(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{
	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;
	

	for (lix = start; lix < stop  && !UI_request; lix+=stepwidth)
	{
		//convert to signed integer
		lvalue1 = SignalData1[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]));
		lvalue2 = SignalData2[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]));

		//scale signals
		lvalue1 = lvalue1 * math_voltage_factor[Selected_Voltage_CH1];
		lvalue2 = lvalue2 * math_voltage_factor[Selected_Voltage_CH2];
		
		//and rescale
		if (lvalue1 > 0)
		lvalue1 /= math_voltage_factor[math_scale];
		else if (lvalue1 < 0)
		{lvalue1 *= -1;lvalue1 /= math_voltage_factor[math_scale]; lvalue1 *= -1;}
		
		if (lvalue2 > 0)
		lvalue2 /= math_voltage_factor[math_scale];
		else if (lvalue2 < 0)
		{lvalue2 *= -1;lvalue2 /= math_voltage_factor[math_scale]; lvalue2 *= -1;}
		
		//predivision
		lvalue1 *= predivisor[MenuStatus[1][3] - 104];
		lvalue2 *= predivisor[MenuStatus[2][3] - 104];

		//calculate math signal
		lbuffer = lvalue1 * lvalue2;
						
		//limiter
		if (lbuffer > (ADC_ZERO+1))
		{ lbuffer = (ADC_ZERO+1);}
		else if (lbuffer < -ADC_ZERO)
		{ lbuffer = -ADC_ZERO;}

		//convert to unsigned and save as char
		MathData[lix] = lbuffer + ADC_ZERO;
	
	}


}
//##########################################################################################################################################################
//subtract signals
void Signal::CalcMathSub(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{

	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;

	for (lix = start; lix < stop  && !UI_request; lix+=stepwidth)
	{
		//convert to signed integer
		lvalue1 = SignalData1[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]));
		lvalue2 = SignalData2[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]));

		//scale signals
		lvalue1 = lvalue1 * math_voltage_factor[Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104];
		lvalue2 = lvalue2 * math_voltage_factor[Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104];
		
		//calculate math signal
		lbuffer = lvalue1 - lvalue2;
		
		//and rescale
		if (lbuffer > 0)
		lbuffer /= math_voltage_factor[math_scale];
		else if (lbuffer < 0)
		{lbuffer *= -1;lbuffer /= math_voltage_factor[math_scale]; lbuffer *= -1;}
		
		//limiter
		if (lbuffer > (ADC_ZERO+1))
		{ lbuffer = (ADC_ZERO+1);}
		else if (lbuffer < -ADC_ZERO)
		{ lbuffer = -ADC_ZERO;}
		
		//convert to unsigned and save as char
		MathData[lix] = lbuffer + ADC_ZERO;
	}


}
//##########################################################################################################################################################
//add signals
void Signal::CalcMathAdd(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{
	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;

	for (lix = start; lix < stop  && !UI_request; lix+=stepwidth)
	//for (lix = draw_start + Trigger_Offset_Calc; lix < lstop && !UI_request; lix+=lfactor)
	{
		//convert to signed integer
		lvalue1 = SignalData1[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]));
		lvalue2 = SignalData2[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]));

		//scale signals
		lvalue1 = lvalue1 * math_voltage_factor[Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104];
		lvalue2 = lvalue2 * math_voltage_factor[Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104];
		
		//calculate math signal
		lbuffer = lvalue1 + lvalue2;

		//and rescale
		if (lbuffer > 0)
		lbuffer /= math_voltage_factor[math_scale];
		else if (lbuffer < 0)
		{ lbuffer *= -1;lbuffer /= math_voltage_factor[math_scale]; lbuffer *= -1;}
		
		//limiter
		if (lbuffer > (ADC_ZERO+1))
		{ lbuffer = (ADC_ZERO+1);}
		else if (lbuffer < -ADC_ZERO)
		{ lbuffer = -ADC_ZERO;}

		//convert to unsigned and save as char
		MathData[lix] = lbuffer + ADC_ZERO;
	}


}
//##########################################################################################################################################################
// BF Signal processing
void Signal::ProcessSignalData(void)
{
	unsigned char *lp_sig1 = NULL;	//pointer to signal 1
	unsigned char *lp_sig2 = NULL;	//pointer to signal 2
	unsigned char *lp_sigM = NULL;	//pointer to math signal 

	int lix, lfactor, lcalcstop;
	short lIntPol_Offs = 0, lDel_IntPol_Offs = 0;


	if (UI_request && (USTB_Mode == USTB_OFF)) return;	

//---------------------------------------------------------------------------------------
//		Calculate drawing parameters
//---------------------------------------------------------------------------------------
	if (Selected_Timebase < 4) //BF 20ns + 10ns + 5ns + 2ns main mode - interpolated signal
	{
		draw_start = 0;
		//if (draw_start < 0) draw_start = 0;

		lIntPol_Offs = (short) MemWinStart + Trigger_Offset_Calc;	//BF #003 interpolation offset 

		//BF not needed    draw_stop  = draw_start + GRID_WIDTH;
		draw_factor = 1;

		//set pointers to signals
		lp_sig1 = &SIGNAL1_Intpolate[0];
		lp_sig2 = &SIGNAL2_Intpolate[0];
		lp_sigM = &SIGNALM_Intpolate[0];
	}
	else if (FFT_Mode != FFT_OFF || USTB_Mode != USTB_OFF)
	{
		draw_start = 0;
		draw_factor = 1;
	}
	else //BF >= 50ns main mode - true signal
	{
		draw_start = (short) MemWinStart + Trigger_Offset_Calc;

		if (draw_start < 0) draw_start = 0;
		
		//BF not needed    draw_stop = draw_start + SIG_Size[ZIT_short] - 1;
		draw_factor = (short) ZoomFactor;
				
		//set pointers to signals
		lp_sig1 = &SIGNAL1[0];
		lp_sig2 = &SIGNAL2[0];
		lp_sigM = &SIGNALM[0];
	}


	if (MenuStatus[10][1] == 1)	//Delayed
	{
		if (ZoomFactorDel < 1) //20ns + 10ns delayed mode  - interpolated signal
		{
			draw_dm_ixstart = 0;	// set to zero because whole interpolation buffer nust be drawn

			//BF del #003 draw_dm_ixoffset = (short) ((float) dmode_Window_Offset_Pos * ZoomFactor) + MemWinStart;
			lDel_IntPol_Offs = MemWinStart + Trigger_Offset_Calc + (short)((float)Cursor_Delayed_1 * ZoomFactor);	//BF #003 Interpolation offset for delayed signal

			draw_dm_ixfactor = (short) ZoomFactorDel;	
		}
		else	// >= 50ns delayed mode - true signal
		{
			//BF del #003 draw_dm_ixstart = MemWinStart + (short)((float)(((GRID_WIDTH / 2) - (short) (Cursor_Delayed_Size / 2)) + dmode_Window_Offset_Pos) * ZoomFactor);
			draw_dm_ixstart = MemWinStart + Trigger_Offset_Calc + (short)((float)Cursor_Delayed_1 * ZoomFactor);	//BF #003

			draw_dm_ixfactor = (short) ZoomFactorDel;	
		}
		lfactor = 1;	// 1 -> calculate all math values
	}	
	else //Main Mode
	{ lfactor = draw_factor; } 

	//width of calculating for math functions
	lcalcstop = draw_start + ((GRID_WIDTH + 30) * draw_factor);
	if (lcalcstop > 16383){lcalcstop = 16383;}



        //--------------------------------------------------------------------------------------
	//        	 ultra slow timebase mode (roll mode / shift mode)
	//--------------------------------------------------------------------------------------
	if (USTB_NewData && !RC_request)
	{
		unsigned char lchannelcnt = 0;
		//get number of active channels
		if (Channel_1_Active) lchannelcnt ++;	
		if (Channel_2_Active) lchannelcnt ++;	
		if (Channel_3_Active) lchannelcnt ++;	
		if (Channel_4_Active) lchannelcnt ++;	

		USTB_NewData = 0;

		//USTB refresh rate 
		switch(Selected_Timebase)
		{
			case 24: USTB_Refresh += (30 / lchannelcnt);	break;	//1S/Div
			case 25: USTB_Refresh += (60 / lchannelcnt);	break;	//2S/Div
			case 26: USTB_Refresh += (600 / lchannelcnt);	break;	//5S/Div
			case 27: USTB_Refresh += 600;	break;	//10S/Div
			case 28: USTB_Refresh += 600;	break;	//20S/Div
			case 29: USTB_Refresh += 600;	break;	//50S/Div
			case 30: USTB_Refresh += 600;	break;	//100S/Div
			case 31: USTB_Refresh += 600;	break;	//200S/Div
		}

		//Check for time pointer overflow
		if(USTB_Roll_idx > GRID_WIDTH)
		USTB_Roll_idx = 0;


		if (USTB_Mode == USTB_ROLL)	//roll mode
		{
			if (Channel_1_Active)	
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL1[0], &SIGNAL1_USTB[0]); }

			if (Channel_2_Active)
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL2[0], &SIGNAL2_USTB[0]); }

			if (Channel_3_Active)
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL3[0], &SIGNAL3_USTB[0]); }

			if (Channel_4_Active)
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL4[0], &SIGNAL4_USTB[0]); }

			//increment time pointer
			USTB_Roll_idx ++;
		}
		else if (USTB_Mode == USTB_SHIFT)	//shift mode
		{
			if (Channel_1_Active)	
			{ USTB_shift_signal(&SIGNAL1[0], &SIGNAL1_USTB[0]); }

			if (Channel_2_Active)
			{ USTB_shift_signal(&SIGNAL2[0], &SIGNAL2_USTB[0]); }

			if (Channel_3_Active)
			{ USTB_shift_signal(&SIGNAL3[0], &SIGNAL3_USTB[0]); }

			if (Channel_4_Active)
			{ USTB_shift_signal(&SIGNAL4[0], &SIGNAL4_USTB[0]); }
		}
	
	}


	//---------------------------------------------------------------------------------------
	//				Noise suppression
	//---------------------------------------------------------------------------------------
	
	if (MenuStatus[MENU_ACQUIRE][2] && USTB_Mode == USTB_OFF && ACQ_NewData)
	//if (MenuStatus[MENU_ACQUIRE][2] && FFT_Mode == FFT_OFF && USTB_Mode == USTB_OFF && (Continius || SingleMode))
	//if (MenuStatus[MENU_ACQUIRE][2] && Selected_Timebase > 3 && FFT_Mode == FFT_OFF && USTB_Mode == USTB_OFF)
	{
		int lstart; 
		int lstop = draw_start + (GRID_WIDTH * draw_factor) + draw_factor;
		int lmin;					//values to the left side
		int lmax;					//values to the right side
		int lsum;					//totals


		if (draw_factor < 4)
		{
			if (Selected_Timebase < 4)
			lstart = MemWinStart + Trigger_Offset_Calc;
			else
			lstart = draw_start;

			lmin = -1;
			lmax = 2;	

			for(int i=lstart;i < lstop ;i+=draw_factor)		// go to next value
			{
				if (Channel_1_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL1[i+f];
				
					SIGNAL1[i] = (unsigned char)(lsum>>2);	// calculate average
				}
				if (Channel_2_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL2[i+f];
				
					SIGNAL2[i] = (unsigned char)(lsum>>2);	// calculate average
				}
				if (Channel_3_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL3[i+f];
				
					SIGNAL3[i] = (unsigned char)(lsum>>2);	// calculate average
				}
				if (Channel_4_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL4[i+f];
				
					SIGNAL4[i] = (unsigned char)(lsum>>2);	// calculate average
				}
			}

		}
		else if (draw_factor == 4 || draw_factor == 5)
		{
			lmin = -3;
			lmax = 4;
	
			for(int i=draw_start;i < lstop ;i+=draw_factor)		// go to next value
			{
				if (Channel_1_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL1[i+f];
					
					SIGNAL1[i] = (unsigned char)(lsum>>3);	// calculate average
				}
				if (Channel_2_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL2[i+f];
					
					SIGNAL2[i] = (unsigned char)(lsum>>3);	// calculate average
				}
				if (Channel_3_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL3[i+f];
					
					SIGNAL3[i] = (unsigned char)(lsum>>3);	// calculate average
				}
				if (Channel_4_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL4[i+f];
					
					SIGNAL4[i] = (unsigned char)(lsum>>3);	// calculate average
				}

			}
		}
		else if (draw_factor >= 10)	
 		{
			lmin = -7;
			lmax = 8;
	
			for(int i=draw_start;i < lstop ;i+=draw_factor)	// go to next value
			{
				if (Channel_1_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL1[i+f];
					
					SIGNAL1[i] = (unsigned char)(lsum>>4);	// calculate average
				}
				if (Channel_2_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL2[i+f];
					
					SIGNAL2[i] = (unsigned char)(lsum>>4);	// calculate average
				}
				if (Channel_3_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL3[i+f];
					
					SIGNAL3[i] = (unsigned char)(lsum>>4);	// calculate average
				}
				if (Channel_4_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL4[i+f];
					
					SIGNAL4[i] = (unsigned char)(lsum>>4);	// calculate average
				}
			}	
		}

	}


        //--------------------------------------------------------------------------------------
	//        	 Interpolation (time stretch) for timebase 20ns, 10ns (5ns)
	//--------------------------------------------------------------------------------------
	if(USTB_Mode == USTB_OFF && FFT_Mode == FFT_OFF)	
	{
		if (Channel_1_Active)
		{	
			if (Selected_Timebase < 4)
			{ Interpolate(Selected_Timebase, lIntPol_Offs, &SIGNAL1[0], &SIGNAL1_Intpolate[0]); }
			
			if ((MenuStatus[10][1] == 1) && (ZoomFactorDel < 1)) //delayed mode
			{ Interpolate(Timebase_Idx - dmode_Selected_Timebase - 1, lDel_IntPol_Offs, &SIGNAL1[0], &SIGNAL1_Intpolate_delayed[0]); }
		}
		
		if (Channel_2_Active)
		{	
			if (Selected_Timebase < 4)
			{ Interpolate(Selected_Timebase, lIntPol_Offs, &SIGNAL2[0], &SIGNAL2_Intpolate[0]); }
			
			if ((MenuStatus[10][1] == 1) && (ZoomFactorDel < 1))	//delayed mode
			{ Interpolate(Timebase_Idx - dmode_Selected_Timebase - 1, lDel_IntPol_Offs, &SIGNAL2[0], &SIGNAL2_Intpolate_delayed[0]); }
		}	
		//4-Channel Version
		if (NumberOfChannels > 2)
		{	
			if (Channel_3_Active)
			{	
				if (Selected_Timebase < 4)
				{ Interpolate(Selected_Timebase, lIntPol_Offs, &SIGNAL3[0], &SIGNAL3_Intpolate[0]); }
				
				if ((MenuStatus[10][1] == 1) && (ZoomFactorDel < 1))	//delayed mode
				{ Interpolate(Timebase_Idx - dmode_Selected_Timebase - 1, lDel_IntPol_Offs, &SIGNAL3[0], &SIGNAL3_Intpolate_delayed[0]); }
			}	
			
			if (Channel_4_Active)
			{		   	
				if (Selected_Timebase < 4)
				{ Interpolate(Selected_Timebase, lIntPol_Offs, &SIGNAL4[0], &SIGNAL4_Intpolate[0]); }
				
				if ((MenuStatus[10][1] == 1) && (ZoomFactorDel < 1))	//delayed mode
				{ Interpolate(Timebase_Idx - dmode_Selected_Timebase - 1, lDel_IntPol_Offs, &SIGNAL4[0], &SIGNAL4_Intpolate_delayed[0]); }
			}
		}	

	}
	


	//---------------------------------------------------------------------------------------
	//				MATH functions
	//---------------------------------------------------------------------------------------
	
	if (Channel_Math_Active == 1)
	{

		//---------------------------------------------
		//         MATH function FFT
		//---------------------------------------------
		if (FFT_Mode != FFT_OFF)               	// fft
		{
			if(FFT_NewData || !Continius)	// BF calculate spectrum
			{ 
				if(Channel_1_Active) FFT_CalcSpectrum(&SIGNAL1[0],&SPECTRUM[0]);
				else if(Channel_2_Active) FFT_CalcSpectrum(&SIGNAL2[0],&SPECTRUM[0]);
				else if(Channel_3_Active) FFT_CalcSpectrum(&SIGNAL3[0],&SPECTRUM[0]);
				else if(Channel_4_Active) FFT_CalcSpectrum(&SIGNAL4[0],&SPECTRUM[0]);
			}	
			
			return;
		}	

		//---------------------------------------------
		//         MATH function multiply
		//---------------------------------------------
		if ((MenuStatus[26][2] == 1) && (Channel_1_Active && Channel_2_Active))      		// multiply 
		{	
			//set global math scaling and offset for drawing routine
			math_scale = math_mul_scale - 166;
			Math_Offset = Math_Mul_Offset;
			
			//calculate main math signal
			CalcMathMul(draw_start, lcalcstop, lfactor, lp_sig1, lp_sig2, lp_sigM);
			
			//calculate delayed math signal
			if ((MenuStatus[10][1] == 1) && ((Timebase_Idx - dmode_Selected_Timebase -1) < 4))	//BF #003
			{ CalcMathMul(0, GRID_WIDTH+1, 1, &SIGNAL1_Intpolate_delayed[0], &SIGNAL2_Intpolate_delayed[0], &SIGNALM_Intpolate_delayed[0]); }
		}	//multiply end

		//---------------------------------------------
		//         MATH function subtract
		//---------------------------------------------

		else if ((MenuStatus[26][3] == 1) && (Channel_1_Active && Channel_2_Active))            	// subtract
		{	
			//set global math scaling and offset for drawing routine
			math_scale = math_sub_scale - 150;
			Math_Offset = Math_Sub_Offset;
			
			//calculate main math signal
			CalcMathSub(draw_start, lcalcstop, lfactor, lp_sig1, lp_sig2, lp_sigM);

			//calculate delayed math signal
			if ((MenuStatus[10][1] == 1) && ((Timebase_Idx - dmode_Selected_Timebase -1) < 4))	//BF #003
			{ CalcMathSub(0, GRID_WIDTH+1, 1, &SIGNAL1_Intpolate_delayed[0], &SIGNAL2_Intpolate_delayed[0], &SIGNALM_Intpolate_delayed[0]); }
		}	//subtract end

		//---------------------------------------------
		//         MATH function add
		//---------------------------------------------
		else if ((MenuStatus[26][4] == 1) && (Channel_1_Active && Channel_2_Active))            	// add
		{
			//set global math scaling and offset for drawing routine
			math_scale = math_add_scale - 150;
			Math_Offset = Math_Add_Offset;
			
			//calculate main math signal
			CalcMathAdd(draw_start, lcalcstop, lfactor, lp_sig1, lp_sig2, lp_sigM);

			//calculate delayed math signal
			if ((MenuStatus[10][1] == 1) && ((Timebase_Idx - dmode_Selected_Timebase -1) < 4))	//BF #003
			{ CalcMathAdd(0, GRID_WIDTH+1, 1, &SIGNAL1_Intpolate_delayed[0], &SIGNAL2_Intpolate_delayed[0], &SIGNALM_Intpolate_delayed[0]); }
		}	//add end
		else if (!Channel_1_Active && Channel_2_Active)
		{
			for(int i=0;i<16383;i++) SIGNALM[i] = ADC_ZERO;			//SIGNAL2[i];
			for(int i=0;i<1199;i++) SIGNALM_Intpolate[i] = ADC_ZERO;	//SIGNAL2_Intpolate[i];
		}
		else if (!Channel_2_Active && Channel_1_Active)
		{
			for(int i=0;i<16383;i++) SIGNALM[i] = ADC_ZERO;			//SIGNAL1[i];
			for(int i=0;i<1199;i++) SIGNALM_Intpolate[i] = ADC_ZERO;	//SIGNAL1_Intpolate[i];
		}
	
		
/*
		else if (MenuStatus[26][5] == 1)            // free -> not available
		{
		for (ix2 = 0; ix2 < 16384; ix2++)
			{
				SIGNALM[ix2] = (unsigned char) ((int) 127 + (((int) SIGNAL1[ix2] - ((ZeroLevelCH1 + (int) 60) >> 1)) - ((int) SIGNAL2[ix2] - ((ZeroLevelCH2 + (int) 60) >> 1))));
			}
		}
*/


	}//Math End


} //Signal processing end 
//##########################################################################################################################################################
// BF Timebase 50ns is the fastest real timebase. For timebase 20nS, 10nS, 5nS and 2nS the additional samples must be interpolated 
// BF replaced complete interpolation with a simplified routine
// BF new linear interpolation
void Signal::Interpolate(int timebase, int start, unsigned char *SignalData, unsigned char *InterpolateResult)
{
    int ix,iy,incr;
	
	if (UI_request) return;	

	//printf("\r\ninterpolation start %d\r\n", start);	

	if(!test_sw2)
	{
		//printf("Linear interpolation on TB %d\r\n", timebase);

		if (timebase == 0)		// 2ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 25);ix+=25,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 25, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 1)		// 5ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 10);ix+=10,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 10, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 2)		// 10ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 5);ix+=5,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 5, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 3)		// 20ns 
		{
			for(ix=0,iy=start,incr=2;ix < (GRID_WIDTH + 25);ix+=incr,iy++)
			{
				//toggle increment
				if(incr == 2){incr = 3;}
				else{incr = 2;}

				LinearInterpolation(ix, (int)SignalData[iy], ix + incr, (int)SignalData[iy+1], InterpolateResult);
			}

		}
		else
		{ printf("\r\nUnsupported timebase %d\r\n", timebase); }
	
	}
	else
	{
		int delta,rx;
		
		//printf("Simple interpolation on TB %d\r\n", timebase);

		if (timebase == 0)		// 2ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-25);ix++,rx+=25)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 25);ix++,rx+=25)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 24 values
				for (int j=1;j <= 24;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 25 -j ) ); }
			}
		}
		else if (timebase == 1)		// 5ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-10);ix++,rx+=10)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 10);ix++,rx+=10)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 9 values
				for (int j=1;j <= 9;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 10 -j ) ); }
			}
		}
		else if (timebase == 2)		// 10ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-5);ix++,rx+=5)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 5);ix++,rx+=5)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 4 values
				for (int j=1;j <= 4;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 5 -j ) ); }
			}
	
		}
		else if (timebase == 3)		// 20ns 
		{
			//for(ix=start,rx=0,incr=1;rx < ((GRID_WIDTH * 2)-3);ix++,rx+=(incr+1))
			for(ix=start,rx=0,incr=1;rx < (GRID_WIDTH + 3);ix++,rx+=(incr+1))
			{
				//toggle increment
				if(incr == 1){incr = 2;}
				else{incr = 1;}
	
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
			
				//interpolate the next 1 - 2  values
				for (int j=1;j <= incr;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( incr + 1 -j ) ); }
			}
		}
		else
		{ printf("\r\nUnsupported timebase %d\r\n", timebase); }

	}
}
//##########################################################################################################################################################
// BF linear interpolation with Bresenham algorithm
void Signal::LinearInterpolation(int x1, int y1, int x2, int y2, unsigned char *interpolation)
{
	
	//--------------------------------------------
	//special case horizontal line
	//--------------------------------------------
	if(y1 == y2)
	{
		if(x1 < x2)
		for(; x1 != x2; x1++)	{ interpolation[x1] = (char)y1; }
		else
		for(; x2 != x1; x2++)	{ interpolation[x2] = (char)y1; }
		return;
	}	

	//--------------------------------------------
	//special case vertical line
	//--------------------------------------------
	else if(x1 == x2)
	{
		if(y1 < y2)
		for(; y1 != y2; y1++)	{ interpolation[x1] = (char)y1; }
		else
		for(; y2 != y1; y2++)	{ interpolation[x1] = (char)y2; }
		return;
	}	

	//-------------------------------------------------------------
	// Bresenham algorithm for drawing diagonal lines
	//-------------------------------------------------------------
	int dy = y2 - y1;
        int dx = x2 - x1;
        int stepx, stepy;

	//check if delta is positive or negative
	if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

	//special case exact 45 degrees delta x / delta y = 1
	if (dx == dy)
	{
		//horizontal and vertical component increment constant with 1 
		if(x1 < x2) 
		{
			if(y1 < y2)
			{ 
				for(; x1 != x2; x1++, y1++)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1++, y1--)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			
		}
		else if(x1 > x2)
		{
			if(y1 < y2) 
			{
				for(; x1 != x2; x1--, y1++)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1--, y1--)
				{ interpolation[x1] = (char)y1; }
				return;
			}
		}
	}

	
        dy <<= 1;                              		// dy is now 2*dy
        dx <<= 1;                              		// dx is now 2*dx
	
	//set starting point
	interpolation[x1] = (char)y1;
	
	//---------------------------------------------
	//between horizontal and 45 degrees
	//---------------------------------------------
	if (dx > dy)
	{
		int fraction = dy - (dx >> 1);   	// same as 2*dy - dx
		while (x1 != x2) {
			if (fraction >= 0) {
			y1 += stepy;
			fraction -= dx;              	// same as fraction -= 2*dx
			}
			x1 += stepx;
			fraction += dy;          	// same as fraction -= 2*dy
			interpolation[x1] = (char)y1;
		}
        	return;
	}

	//---------------------------------------------
	//between vertical and 45 degrees
	//---------------------------------------------
	if (dx < dy)
	{
		int fraction = dx - (dy >> 1);
		while (y1 != y2) {
			if (fraction >= 0) {
			x1 += stepx;
			fraction -= dy;
			}
			y1 += stepy;
			fraction += dx;
			interpolation[x1] = (char)y1;
		}
		return;
        }

}

//##########################################################################################################################################################

// BF -> generate test signals on all channels
void Signal::TestSignalGenerate(void)
{
	int ix, iy, tog, pw;
	int  lVirtual_Zero = 0;
	char lDCOffset     = 0;

	if (Channel_1_Active)	// draw rectangle signal
	{
		lVirtual_Zero = ADC_ZERO + (int)((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
		// Signal 1 (Yellow)
		tog = 0;
		iy = lVirtual_Zero + 100;		//Amplitude

		if ( MenuStatus[MENU_CHANNEL1][0] == 8) 	//AC
		lDCOffset = 0;//-20;
		else if ( MenuStatus[MENU_CHANNEL1][0] == 7)	//DC
		lDCOffset = 0;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL1[ix] = lVirtual_Zero;
		}
		
		if ( MenuStatus[MENU_CHANNEL1][0] != 6)
		for (ix = 0, pw = 0; (ix < 16384) && !UI_request; ix++, pw++)
		{	
			//if (ix %200 == 0) 		//Pulswidth
			//if (ix %50 == 0) 		//Pulswidth
			if(pw==50)			//Pulswidth
			{
				pw = 0;
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (tog == 0)
			{ iy = lVirtual_Zero - 73; }	//Amplitude
			else
			{ iy = lVirtual_Zero + 72;}	//Amplitude
	
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;
		
			SIGNAL1[ix] = (char)iy + lDCOffset;
		}	
	
	}

	if (Channel_2_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 2 (Green)
		tog = 0;	
		iy = lVirtual_Zero;
	
		if ( MenuStatus[MENU_CHANNEL2][0] == 8) 	//AC
		lDCOffset = 0;
		else if ( MenuStatus[MENU_CHANNEL2][0] == 7)	//DC
		lDCOffset = 20;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL2[ix] = lVirtual_Zero;
		}

		if ( MenuStatus[MENU_CHANNEL2][0] != 6)
		// calculate sinus signal
		for (ix = 0, iy = 0; (ix < 16384) && !UI_request; ix++, iy+=4)
		{
			if(iy >= 1024)
			iy = 0;

			SIGNAL2[ix] = lVirtual_Zero + (iSin1024[iy] >> 4);
		}
		
/*
		// calculate triangle signal
		for (ix = 0; (ix < 16384) && !UI_request; ix++)
		{
			if (ix %80 == 0)
			{
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (ix %2 == 0)
			{
				if (tog == 0) iy++;
				else iy--;
			}
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;

			SIGNAL2[ix] = (char)iy + lDCOffset;
		}	
*/	
	}

	if (NumberOfChannels == 2)
	return;

	if (Channel_3_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / scale_factor[Selected_Voltage_CH3][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 3 (Purple)
		tog = 0;	
		iy = lVirtual_Zero + 25;
		
		if ( MenuStatus[MENU_CHANNEL3][0] == 8) 	//AC
		lDCOffset = -30;
		else if ( MenuStatus[MENU_CHANNEL3][0] == 7)	//DC
		lDCOffset = 0;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL3[ix] = lVirtual_Zero;
		}

		
		if ( MenuStatus[MENU_CHANNEL3][0] != 6)
		for (ix = 0, pw = 0; (ix < 16384) && !UI_request; ix++,pw++)
		{	
			//if (ix %150 == 0) 		//Pulswidth
			if (pw == 150) 			//Pulswidth
			{
				pw = 0;
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (tog == 0)
			{ iy = lVirtual_Zero - 25; }	//Amplitude
			else
			{ iy = lVirtual_Zero + 25;}	//Amplitude
	
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;
		
			SIGNAL3[ix] = (char)iy + lDCOffset;
		}	
	}

	if (Channel_4_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / scale_factor[Selected_Voltage_CH4][GainIdx]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 4 (Red)
		tog = 0;	
		iy = lVirtual_Zero;
		
		
		if ( MenuStatus[MENU_CHANNEL4][0] == 8) 	//AC
		lDCOffset = 0;
		else if ( MenuStatus[MENU_CHANNEL4][0] == 7)	//DC
		lDCOffset = 25;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL4[ix] = lVirtual_Zero;
		}
	
		if ( MenuStatus[MENU_CHANNEL4][0] != 6)
		for (ix = 0; (ix < 16384) && !UI_request; ix++)
		{
			if (ix %100 == 0)			//period
			{
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (ix %2 == 0)	 			//Amplitude
			{
				if (tog == 0) iy++;
				else iy--;
			}
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;

			SIGNAL4[ix] = (char)iy + lDCOffset;
		}	
	}
	if(FFT_Mode != FFT_OFF)
	FFT_NewData = 1;


}
//##########################################################################################################################################################
//BF for combi-trigger
void Signal::CalcMinMax(int start, int stop, int stepwidth ,unsigned char *SignalData1,  unsigned char *min, unsigned char *max){
  	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;
	
	*min=255;
	*max=0;

	for (lix = start; lix < stop; lix+=stepwidth)
	{
		//convert to signed integer
		if (SignalData1[lix]>*max)
			*max=SignalData1[lix];
		if (SignalData1[lix]<*min)
			*min=SignalData1[lix];
	}
}

//##########################################################################################################################################################
//calculate square root
int Signal::iSqrt(int op)
{
/*
	//int op = num;
	int res = 0;
	int one = 1 << 14; // The second-to-top bit is set: 1L<<30 for long
	
	// "one" starts at the highest power of four <= the argument.
	while (one > op)
	{ one >>= 2; }
	
	while (one != 0)
	{
		if (op >= res + one)
		{
			op = op - res + one;
			res = res + (one<<1);
		}
		res >>= 1;
		one >>= 2;
	}
	return res;
*/
	int l,r;
	// and square root
	for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
	r = (r + (op / r)) >> 1;

	return r;


}



